unit SDIMAIN;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus, sysutils,
  Dialogs, StdCtrls, Buttons, ExtCtrls,  ImgList, StdActns,
  ActnList, ToolWin, ComCtrls, AppEvnts, Messages;

const
 countRecFileResults = 20; //-    

type
 TRecFileResult = record
   FCountRows : integer;
   FCountBalls : integer;
   FName_ : string;
 end;

 {  :
     + chr(13)
   -     + chr(13)
   -     + chr(13)
    + chr(13)
   ......
     2 + chr(13)
   -     + chr(13)
   -     + chr(13)
    + chr(13)
 }
 EFileError =class(Exception);
 TFileResults = class(TObject)
  public
   FResult : array [1..countRecFileResults] of TRecFileResult;
   FResultBalls : array [1..countRecFileResults] of TRecFileResult;
   procedure Clear;
   procedure Load_;
   procedure Save_;
   function FindPos(rec: TRecFileResult) : integer;
   function FindPosBall(rec: TRecFileResult) : integer;
   procedure InsRes(rec : TRecFileResult);
   procedure InsResBall(rec : TRecFileResult);
   procedure ShowResults;
   procedure ChiperXOR(buff_,key_ : pointer; size_buff,size_key : integer);
 end;

  TSDIAppForm = class(TForm)
    StatusBar: TStatusBar;
    Panel1: TPanel;
    ImageGlass: TImage;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ScrollBox1: TScrollBox;
    ImageNext: TImage;
    Timer1: TTimer;
    LabelCountRow: TLabel;
    ApplicationEvents1: TApplicationEvents;
    ButtonPause: TButton;
    Label3: TLabel;
    LabelBalls: TLabel;
    N2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ApplicationEvents1ShortCut(var Msg: TWMKey; var Handled: Boolean);
    procedure ButtonPauseClick(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SDIAppForm: TSDIAppForm;
  side_square : integer = 25;       //   

implementation

uses about,TableResults,EditName;

{$R *.dfm}

const min_x = 1;
      max_x = 10;
      min_y = 1;
      max_y = 25;
      side_small_square = 20; //    

      fileResults = 'results.tet';
      keyChiper = '  ';
      keyChiper2 = ' ';

type
 TArrayGlass = array [min_x..max_x,min_y..max_y] of 0..1;

 TK =record //    k1
   k1,k2,k3,k4 : TPoint;
 end;

 TFigure =class(TObject)
//      k1
  protected
    FK : TK;
    FK_breakMove : array [1..4] of TPoint; //    -  . (0,0)  
    procedure rotate_; virtual;
    procedure GetSize(var xl,xr,yt,yb : integer);
    constructor create;
 end;

 TFigureA =class(TFigure)
{         _ _ _ _
 : |_|_|_|_|
            |
         }
  protected
    constructor create;
 end;

 TFigureB = class(TFigure)
 {            _
            _|_|_
  :  |_|_|_|
              |
          }
  protected
    constructor create;
 end;

 TFigureC = class(TFigure)
 {
            _ _ _
  :  |_|_|_|
              ||_|
              |
          }
  protected
    constructor create;
 end;

 TFigureD = class(TFigure)
 {          _ _ _
  :  |_|_|_|
           |_||
              |
          }
  protected
    constructor create;
 end;

 TFigureE = class(TFigure)
 {          _ _
           |_|_|
  :  |_|_|
              |
          }
  protected
    constructor create;
 end;

 TFigureF = class(TFigure)
 {          _ _
           |_|_|_
             |_|_|
  :     |
             
}
  protected
    constructor create;
 end;

 TFigureG = class(TFigure)
{               _ _
   :    _|_|_|
             |_|_|
                |
            
}
  protected
    constructor create;
 end;

 TGlass =class(TObject)
  private
   procedure SetCountFillLines(const Value: integer);
   procedure SetCountBalls(const Value: integer);
  protected
//    FArray 0 - , 1 - 
   FArray : array [min_x..max_x,min_y..max_y] of 0..1;
   FFigure : TFigure;
   FFigureNext : TFigure;
   FCountFillLines : integer; //  
   FCountBalls      :integer; // 
   FFactor1MulBalls : double; //  ,   

   FImageGlass : TImage;
   FImageNext  : TImage;

   property countFillLines : integer read FCountFillLines write SetCountFillLines;
   property countBalls : integer read FCountBalls write SetCountBalls;
   procedure OutElement(p: TPoint; isEmpty: boolean=true; is_small : boolean = false; l : integer =0; t : integer =0);
   procedure Clear;
   procedure outFigure(out_Next : boolean =false);
{  moveFigure: x -   x, y -   y
                        x = 0  y = 0 - }
   function moveFigure(x,y : integer) : boolean; //true -  / 
   procedure NextFigure;
   procedure RemoveLines;
   procedure CheckResult;
   constructor Create(imageGlass,imageNext : TImage);
   destructor Destroy; override;

//    ,      min_y -1
   function TopNonEmptyRow : integer;
 end;

var glassA : TGlass;
    file_ : TFileResults;

{ TFigure }

constructor TFigure.create;
var i : integer;
begin
 inherited create;
 for i := low(FK_breakMove) to high(FK_breakMove) do
   FK_breakMove[i] :=point(0,0);
end;

procedure TFigure.GetSize(var xl, xr, yt, yb: integer);
begin
xl :=0; xr :=0; yt :=0; yb :=0;
if xl > FK.k2.X then xl :=FK.k2.X;
if xl > FK.k3.X then xl :=FK.k3.X;
if xl > FK.k4.X then xl :=FK.k4.X;

if xr < FK.k2.X then xr :=FK.k2.X;
if xr < FK.k3.X then xr :=FK.k3.X;
if xr < FK.k4.X then xr :=FK.k4.X;

if yt > FK.k2.y then yt :=FK.k2.y;
if yt > FK.k3.y then yt :=FK.k3.y;
if yt > FK.k4.y then yt :=FK.k4.y;

if yb < FK.k2.y then yb :=FK.k2.y;
if yb < FK.k3.y then yb :=FK.k3.y;
if yb < FK.k4.y then yb :=FK.k4.y;
end;

procedure TFigure.rotate_;
var p : TPoint;
    i : integer;
begin
//      FK.k1
 p.X :=FK.k2.Y; p.Y :=-FK.k2.X; FK.k2 :=p;
 p.X :=FK.k3.Y; p.Y :=-FK.k3.X; FK.k3 :=p;
 p.X :=FK.k4.Y; p.Y :=-FK.k4.X; FK.k4 :=p;

 for i := low(FK_breakMove) to high(FK_breakMove) do begin
   p.X :=FK_breakMove[i].Y; p.Y :=-FK_breakMove[i].X; FK_breakMove[i] :=p;
 end; //for i
end;

{ TFigureA }

constructor TFigureA.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(1,0);
 FK.k4 :=point(2,0);

 FK_breakMove[1] :=point(-1,1);
 FK_breakMove[2] :=point(0,1);
 FK_breakMove[3] :=point(1,-1);
 FK_breakMove[4] :=point(2,-1);
end;

{ TFigureB }

constructor TFigureB.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(0,1);
 FK.k4 :=point(1,0);

 FK_breakMove[1] :=point(-1,1);
 FK_breakMove[2] :=point(1,1);
 FK_breakMove[3] :=point(1,-1);
 FK_breakMove[4] :=point(0,0);
end;

{ TFigureC }

constructor TFigureC.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(1,0);
 FK.k4 :=point(1,-1);

 FK_breakMove[1] :=point(0,-1);
 FK_breakMove[2] :=point(-1,1);
 FK_breakMove[3] :=point(0,0);
 FK_breakMove[4] :=point(0,0);
end;

{ TFigureD }

constructor TFigureD.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(-1,-1);
 FK.k4 :=point(1,0);

 FK_breakMove[1] :=point(0,-1);
 FK_breakMove[2] :=point(0,1);
 FK_breakMove[3] :=point(0,0);
 FK_breakMove[4] :=point(0,0);
end;

{ TFigureE }

constructor TFigureE.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(-1,1);
 FK.k4 :=point(0,1);

 FK_breakMove[1] :=point(1,1);
 FK_breakMove[2] :=point(1,0);
 FK_breakMove[3] :=point(0,0);
 FK_breakMove[4] :=point(0,0);
end;

{ TFigureF }

constructor TFigureF.create;
begin
 inherited create;
 FK.k2 :=point(-1,1);
 FK.k3 :=point(0,1);
 FK.k4 :=point(1,0);

 FK_breakMove[1] :=point(1,-1);
 FK_breakMove[2] :=point(0,1);
 FK_breakMove[3] :=point(1,0);
 FK_breakMove[4] :=point(0,0);
end;

{ TFigureG }

constructor TFigureG.create;
begin
 inherited create;
 FK.k2 :=point(-1,0);
 FK.k3 :=point(0,1);
 FK.k4 :=point(1,1);

 FK_breakMove[1] :=point(1,0);
 FK_breakMove[2] :=point(-1,1);
 FK_breakMove[3] :=point(0,0);
 FK_breakMove[4] :=point(0,0);
end;

{ TGlass }

procedure TGlass.CheckResult;
var r : TRecFileResult;
    f : TFormEditName;
begin
 file_.Load_;
 r.FCountRows :=countFillLines;
 r.FCountBalls :=countBalls;
 if (file_.FindPos(r) > 0) or (file_.FindPosBall(r) > 0) then begin
   f :=TFormEditName.Create(Application);
   f.FName_ :=@(r.FName_);
   if f.ShowModal = mrOK then begin
     file_.InsRes(r);
     file_.InsResBall(r);
     file_.Save_;
     file_.ShowResults;
   end;
 end;
end;

procedure TGlass.Clear;
var i,j : integer;
begin
 for i := min_x to max_x do
   for j := min_y to max_y do begin
     FArray[i,j] :=0;
     OutElement(point(i,j));
   end; //for j
end;

constructor TGlass.Create(imageGlass,imageNext : TImage);
begin
 inherited Create;
 FFigure     :=nil;
 FFigureNext :=nil;
 countFillLines :=0;
 countBalls      :=0;
 FFactor1MulBalls :=1;

 FImageGlass :=imageGlass;
 FImageNext  :=imageNext;
end;

destructor TGlass.Destroy;
begin
 FFigure.Free;
 FFigureNext.Free;
 inherited Destroy;
end;

function TGlass.moveFigure(x,y : integer): boolean;
var curr_ : TK;
    i : integer;
    p : TPoint;
begin
 Result :=true;
 curr_ :=FFigure.FK;
//     
 if (x=0) and (y=0) then
   for i := low(FFigure.FK_breakMove) to high(FFigure.FK_breakMove) do begin
     p :=point(FFigure.FK.k1.X + FFigure.FK_breakMove[i].X,
               FFigure.FK.k1.Y + FFigure.FK_breakMove[i].Y);
     if ((p.X <> FFigure.FK.k1.X) or (p.Y <> FFigure.FK.k1.Y)) and
        ((p.X < low(FArray)) or (p.X > high(FArray)) or
         (p.Y < low(FArray[low(FArray)])) or
         (p.Y > high(FArray[low(FArray)])) or
         (FArray[p.X,p.Y] = 1))
      then begin
       Result :=false;
       break;
     end;
   end; //for i

// /
 if Result then begin
   if (x=0) and (y=0) then FFigure.rotate_
    else begin
      FFigure.FK.k1.X :=FFigure.FK.k1.X+x;
      FFigure.FK.k1.Y :=FFigure.FK.k1.Y+y;
    end;
//  /
   if (FFigure.FK.k1.X < min_x) or
      (FFigure.FK.k1.X > max_x) or
      (FFigure.FK.k1.Y < min_y) or
      (FFigure.FK.k1.Y > max_y) or
      (FFigure.FK.k1.X + FFigure.FK.k2.X < min_x) or
      (FFigure.FK.k1.X + FFigure.FK.k2.X > max_x) or
      (FFigure.FK.k1.Y + FFigure.FK.k2.Y < min_y) or
      (FFigure.FK.k1.Y + FFigure.FK.k2.Y > max_y) or
      (FFigure.FK.k1.X + FFigure.FK.k3.X < min_x) or
      (FFigure.FK.k1.X + FFigure.FK.k3.X > max_x) or
      (FFigure.FK.k1.Y + FFigure.FK.k3.Y < min_y) or
      (FFigure.FK.k1.Y + FFigure.FK.k3.Y > max_y) or
      (FFigure.FK.k1.X + FFigure.FK.k4.X < min_x) or
      (FFigure.FK.k1.X + FFigure.FK.k4.X > max_x) or
      (FFigure.FK.k1.Y + FFigure.FK.k4.Y < min_y) or
      (FFigure.FK.k1.Y + FFigure.FK.k4.Y > max_y) or
      (FArray[FFigure.FK.k1.X,FFigure.FK.k1.Y] = 1) or
      (FArray[FFigure.FK.k1.X + FFigure.FK.k2.X,FFigure.FK.k1.Y + FFigure.FK.k2.Y] = 1) or
      (FArray[FFigure.FK.k1.X + FFigure.FK.k3.X,FFigure.FK.k1.Y + FFigure.FK.k3.Y] = 1) or
      (FArray[FFigure.FK.k1.X + FFigure.FK.k4.X,FFigure.FK.k1.Y + FFigure.FK.k4.Y] = 1)
   then begin
     Result :=false;
     FFigure.FK :=curr_;
   end;
 end;

// 
 if Result then begin
   outFigure;
   if ((curr_.k1.X <> FFigure.FK.k1.X) or (curr_.k1.Y <> FFigure.FK.k1.Y)) and
      ((curr_.k1.X <> FFigure.FK.k1.X + FFigure.FK.k2.X) or
       (curr_.k1.Y <> FFigure.FK.k1.Y + FFigure.FK.k2.Y)) and
      ((curr_.k1.X <> FFigure.FK.k1.X + FFigure.FK.k3.X) or
       (curr_.k1.Y <> FFigure.FK.k1.Y + FFigure.FK.k3.Y)) and
      ((curr_.k1.X <> FFigure.FK.k1.X + FFigure.FK.k4.X) or
       (curr_.k1.Y <> FFigure.FK.k1.Y + FFigure.FK.k4.Y))
   then OutElement(curr_.k1);
   if ((curr_.k1.X + curr_.k2.X <> FFigure.FK.k1.X) or
       (curr_.k1.Y + curr_.k2.Y <> FFigure.FK.k1.Y)) and
      ((curr_.k1.X + curr_.k2.X <> FFigure.FK.k1.X + FFigure.FK.k2.X) or
       (curr_.k1.Y + curr_.k2.Y <> FFigure.FK.k1.Y + FFigure.FK.k2.Y)) and
      ((curr_.k1.X + curr_.k2.X <> FFigure.FK.k1.X + FFigure.FK.k3.X) or
       (curr_.k1.Y + curr_.k2.Y <> FFigure.FK.k1.Y + FFigure.FK.k3.Y)) and
      ((curr_.k1.X + curr_.k2.X <> FFigure.FK.k1.X + FFigure.FK.k4.X) or
       (curr_.k1.Y + curr_.k2.Y <> FFigure.FK.k1.Y + FFigure.FK.k4.Y))
   then OutElement(point(curr_.k1.X + curr_.k2.X,curr_.k1.Y + curr_.k2.Y));
   if ((curr_.k1.X + curr_.k3.X <> FFigure.FK.k1.X) or
       (curr_.k1.Y + curr_.k3.Y <> FFigure.FK.k1.Y)) and
      ((curr_.k1.X + curr_.k3.X <> FFigure.FK.k1.X + FFigure.FK.k2.X) or
       (curr_.k1.Y + curr_.k3.Y <> FFigure.FK.k1.Y + FFigure.FK.k2.Y)) and
      ((curr_.k1.X + curr_.k3.X <> FFigure.FK.k1.X + FFigure.FK.k3.X) or
       (curr_.k1.Y + curr_.k3.Y <> FFigure.FK.k1.Y + FFigure.FK.k3.Y)) and
      ((curr_.k1.X + curr_.k3.X <> FFigure.FK.k1.X + FFigure.FK.k4.X) or
       (curr_.k1.Y + curr_.k3.Y <> FFigure.FK.k1.Y + FFigure.FK.k4.Y))
   then OutElement(point(curr_.k1.X + curr_.k3.X,curr_.k1.Y + curr_.k3.Y));
   if ((curr_.k1.X + curr_.k4.X <> FFigure.FK.k1.X) or
       (curr_.k1.Y + curr_.k4.Y <> FFigure.FK.k1.Y)) and
      ((curr_.k1.X + curr_.k4.X <> FFigure.FK.k1.X + FFigure.FK.k2.X) or
       (curr_.k1.Y + curr_.k4.Y <> FFigure.FK.k1.Y + FFigure.FK.k2.Y)) and
      ((curr_.k1.X + curr_.k4.X <> FFigure.FK.k1.X + FFigure.FK.k3.X) or
       (curr_.k1.Y + curr_.k4.Y <> FFigure.FK.k1.Y + FFigure.FK.k3.Y)) and
      ((curr_.k1.X + curr_.k4.X <> FFigure.FK.k1.X + FFigure.FK.k4.X) or
       (curr_.k1.Y + curr_.k4.Y <> FFigure.FK.k1.Y + FFigure.FK.k4.Y))
   then OutElement(point(curr_.k1.X + curr_.k4.X,curr_.k1.Y + curr_.k4.Y));
 end;
end;

procedure TGlass.NextFigure;
  function getFigure : TFigure;
   begin
     Result :=nil;
     case Random(7) of
       0: Result :=TFigureA.create;
       1: Result :=TFigureB.create;
       2: Result :=TFigureC.create;
       3: Result :=TFigureD.create;
       4: Result :=TFigureE.create;
       5: Result :=TFigureF.create;
       6: Result :=TFigureG.create;
     end; //case
     Result.FK.k1 :=point(0,0);
   end;
begin
 if FFigureNext <> nil
   then FFigure :=FFigureNext
   else FFigure :=getFigure;
 FFigure.FK.k1 :=point(0,0);

 FFigureNext :=getFigure;
//  
 FImageNext.Canvas.Brush.Color :=clSilver;
 FImageNext.Canvas.FillRect(FImageNext.ClientRect);
 outFigure(true);
end;

procedure TGlass.OutElement(p: TPoint; isEmpty: boolean=true; is_small : boolean = false; l : integer =0; t : integer =0);
var r : TRect;
    image_ : TImage;
begin
//  Canvas
 if is_small  then begin
   r.Top :=t - p.Y*side_small_square +1; r.Bottom :=r.Top + side_small_square-1;
   r.Left :=l + (p.X - 1)*side_small_square;  r.Right :=r.Left + side_small_square-1;
   image_ :=FImageNext;
 end else begin
   r.Top :=SDIAppForm.ImageGlass.Height-1 - p.Y*side_square +1;
   r.Bottom :=r.Top + side_square-1;
   r.Left :=(p.X - 1)*side_square;   r.Right  :=r.Left + side_square-1;
   image_ :=FImageGlass;
 end;
// 
 if isEmpty then begin
   image_.Canvas.Brush.Color :=clSilver;
   image_.Canvas.FillRect(r);
  end else begin
   image_.Canvas.Brush.Color :=clBlack;
   image_.Canvas.FrameRect(r);
   image_.Canvas.Brush.Color :=clMedGray;
   r.Top :=r.Top+1; r.Left :=r.Left+1;
   r.Bottom :=r.Bottom-1; r.Right :=r.Right-1;
   image_.Canvas.FillRect(r);
 end; //if isEmpty
end;

procedure TGlass.outFigure(out_Next : boolean);
var p : TPoint;
    i : integer;
    f : TFigure;
    xl,xr,yt,yb,l,t : integer;
begin
 l :=0; t :=0;
 if out_Next then begin
   f :=FFigureNext;
//       
   f.GetSize(xl,xr,yt,yb);
   f.FK.k1.X :=f.FK.k1.X -xl+1;
   f.FK.k1.Y :=f.FK.k1.Y -yt+1;
   l :=(FImageNext.Width - (xr-xl+1)*side_small_square) div 2;
   t :=(FImageNext.Width +(yb-yt+1)*side_small_square) div 2;
  end else f :=FFigure;

 for i := 1 to 4 do begin
   case i of
    1 : p :=f.FK.k1;
    2 : p :=point(f.FK.k1.X+f.FK.k2.X,f.FK.k1.Y+f.FK.k2.Y);
    3 : p :=point(f.FK.k1.X+f.FK.k3.X,f.FK.k1.Y+f.FK.k3.Y);
    4 : p :=point(f.FK.k1.X+f.FK.k4.X,f.FK.k1.Y+f.FK.k4.Y);
   end; //case
   if out_Next or ((p.X >=min_x) and (p.X <=max_x) and
                   (p.Y >=min_y) and (p.X <=max_y) and
                   (FArray[p.X,p.Y] = 0))
    then outElement(p,false,out_Next,l,t);
 end; //for
end;

procedure TGlass.RemoveLines;
 function CheckLine(y : integer) : boolean;
  var x : integer;
  begin
    Result :=true;
    for x := low(FArray) to high(FArray) do
      if FArray[x,y]=0 then begin
        Result :=false;
        break;
      end;
  end;
 var order_ : array [min_y..max_y]of integer;
     i,j,k : integer;
     factor2 : integer; //  ,     

begin
  i :=min_y; k :=-1; factor2 :=0;
  for j  := min_y to max_y do
    if not CheckLine(j) then begin
      order_[i] :=j;
      inc(i);
    end else begin
      if k =-1 then k :=j;
      countFillLines :=countFillLines +1;
      inc(factor2);
      countBalls :=countBalls + trunc(max_x * FFactor1MulBalls * factor2);
    end;

  if k <>-1  then begin

    for j := i to max_y do order_[j] :=-1;

    for i := min_y to max_y do
     if order_[i] <> i then
       if order_[i] <> -1 then
         for j  := min_x to max_x do
           FArray[j,i] :=FArray[j,order_[i]]
        else
         for j  := min_x to max_x do
           FArray[j,i] :=0;

   for i := k to max_y do
      for j := min_x to max_x do
       OutElement(point(j,i),FArray[j,i]=0);
  end;

end;

procedure TGlass.SetCountBalls(const Value: integer);
begin
  FCountBalls := Value;
  SDIAppForm.LabelBalls.Caption :=IntToStr(Value);
end;

procedure TGlass.SetCountFillLines(const Value: integer);
var a : cardinal;
begin
  FCountFillLines := Value;
  SDIAppForm.LabelCountRow.Caption :=IntToStr(Value);

  case CountFillLines of
   0..10  : a :=800; //0.8 - 
   11..20 : a :=700;
   21..30 : a :=600;
   31..40 : a :=500;
   41..50 : a :=400;
   51..60 : a :=300;
   61..70 : a :=200;
   71..80 : a :=100;
   else
     a :=80;
  end;
  if SDIAppForm.Timer1.Interval <> a  then begin
    SDIAppForm.Timer1.Interval :=a;
    FFactor1MulBalls :=800 /a;
  end;
end;

function TGlass.TopNonEmptyRow: integer;
var x,y : integer;
begin
 Result :=min_y -1;
 for y := max_y downto min_y do begin
   for x := min_x to max_x do 
     if FArray[x,y] <> 0 then begin
       Result :=y;
       break;
     end;
   if Result <> min_y -1 then break;
 end; //for y
end;

procedure TSDIAppForm.ApplicationEvents1ShortCut(var Msg: TWMKey; var Handled: Boolean);
begin
 if self.Timer1.Enabled then begin
   if Msg.CharCode =VK_DOWN then glassA.moveFigure(0,-1)
    else if Msg.CharCode =VK_LEFT then glassA.moveFigure(-1,0)
    else if Msg.CharCode =VK_RIGHT then glassA.moveFigure(1,0)
    else if Msg.CharCode =VK_UP then glassA.moveFigure(0,0)
    else if Msg.CharCode =VK_SPACE then
      while glassA.moveFigure(0,-1) do;

   Handled :=true;
 end;
end;

procedure TSDIAppForm.Button1Click(Sender: TObject);
begin
 Timer1.Enabled :=false;
 glassA.FFigure.Free;     glassA.FFigure     :=nil;
 glassA.FFigureNext.Free; glassA.FFigureNext :=nil;
 glassA.NextFigure;
 glassA.Clear;
 glassA.countFillLines :=0;
 glassA.countBalls :=0;
 Timer1.Enabled :=true;
end;

procedure TSDIAppForm.ButtonPauseClick(Sender: TObject);
begin
 if Timer1.Enabled then begin
   Timer1.Enabled :=false;
   MessageBox(Handle,'     .',PChar(Caption + ' ()'),MB_ICONINFORMATION);
   Timer1.Enabled :=true;
 end;
end;

procedure TSDIAppForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 glassA.Free;
 file_.Free;
end;

procedure TSDIAppForm.FormCreate(Sender: TObject);
var a : integer;
begin
 Caption :=Application.Title;

//      
//------------------------------------------------
//     
 a :=Height - ClientHeight;
//   StatusBar
 a :=a + StatusBar.Height;
//  
 a :=a + Panel1.Top;
//   StatusBar    Panel
 a :=a + Panel1.Top + Panel1.Height - ImageGlass.Height;
//      
 while ((a + max_y * side_square) > screen.Height -50)  and (side_square > 0) do
   dec(side_square);
 if side_square = 0  then begin
   MessageBox(Handle,'      .  .',PChar(Caption),MB_OK + MB_ICONSTOP);
   halt;
 end;

 Height :=a + max_y * side_square;
 Panel1.Height :=Panel1.Height - ImageGlass.Height + max_y * side_square;
 Panel1.Width  :=Panel1.Width - ImageGlass.Width + max_x *side_square;
 ImageGlass.Height :=max_y * side_square;
 ImageGlass.Width  :=max_x *side_square;

 Randomize;
 ImageNext.Canvas.Brush.Color :=clSilver;
 ImageNext.Canvas.FillRect(ImageNext.ClientRect);
 glassA :=TGlass.Create(ImageGlass,imageNext);
 glassA.Clear;

 file_ :=TFileResults.Create;
end;

procedure TSDIAppForm.N1Click(Sender: TObject);
var f : boolean;
begin
 f :=Timer1.Enabled;
 Timer1.Enabled :=false;
 try
   TAboutBox.Create(Application).ShowModal;
 finally
  Timer1.Enabled :=f;
 end;
end;

procedure TSDIAppForm.N2Click(Sender: TObject);
var f : boolean;
begin
 f :=Timer1.Enabled;
 Timer1.Enabled :=false;
 try
  file_.Load_;
  file_.ShowResults;
 finally
  Timer1.Enabled :=f;
 end;
end;

procedure TSDIAppForm.Timer1Timer(Sender: TObject);
var f : boolean;
begin
//     
 if (glassA.FFigure.FK.k1.X = 0) and (glassA.FFigure.FK.k1.Y = 0) then begin
// 
   if glassA.FFigure is TFigureE then glassA.FFigure.FK.k1.X :=6
                                 else glassA.FFigure.FK.k1.X :=5;
   glassA.FFigure.FK.k1.Y :=max_y;
//   
   with glassA, glassA.FFigure do begin
     if ((FK.k1.y <= max_y) and (FArray[FK.k1.x,FK.k1.y] = 1)) or
        ((FK.k1.y+FK.k2.y <= max_y) and (FArray[FK.k1.x+FK.k2.x,FK.k1.y+FK.k2.y] = 1)) or
        ((FK.k1.y+FK.k3.y <= max_y) and (FArray[FK.k1.x+FK.k3.x,FK.k1.y+FK.k3.y] = 1)) or
        ((FK.k1.y+FK.k4.y <= max_y) and (FArray[FK.k1.x+FK.k4.x,FK.k1.y+FK.k4.y] = 1))
     then begin
       Timer1.Enabled :=false;
       glassA.CheckResult;
     end else outFigure;
   end; //with
//  ( )
 end else
   if not glassA.moveFigure(0,-1) then begin
     f :=true;
     with glassA.FFigure do begin
       if FK.k1.y <= max_y then
         glassA.FArray[FK.k1.X,FK.k1.y] :=1
        else f :=false;
       if FK.k1.y+FK.k2.y <= max_y then
         glassA.FArray[FK.k1.X+FK.k2.X,FK.k1.y+FK.k2.y] :=1
        else f :=false;
       if FK.k1.y+FK.k3.y <= max_y then
         glassA.FArray[FK.k1.X+FK.k3.X,FK.k1.y+FK.k3.y] :=1
        else f :=false;
       if FK.k1.y+FK.k4.y <= max_y then
         glassA.FArray[FK.k1.X+FK.k4.X,FK.k1.y+FK.k4.y] :=1
        else f :=false;
     end;
     if f then
       glassA.countBalls :=glassA.countBalls + trunc(4* glassA.FFactor1MulBalls);
     glassA.RemoveLines;
     glassA.FFigure.Free; glassA.FFigure :=nil;
     if f then glassA.NextFigure
          else begin
            Timer1.Enabled :=false;
            glassA.CheckResult;
          end;
   end;
end;

{ TFileResults }

procedure TFileResults.ChiperXOR(buff_, key_: pointer; size_buff,size_key: integer);
var i,j : integer;
    pb,pk : pByte;
begin
 pb :=buff_; pk :=key_; j :=1;
 for i :=1 to size_buff do begin
  pb^ :=pb^ xor pk^;
  inc(pb);
  if j = size_key then begin
    j :=1; pk :=key_;
   end else begin
    inc(j); inc(pk);
  end;
 end;
end;

procedure TFileResults.Clear;
var i : integer;
begin
 for i := 1 to countRecFileResults do begin
   FResult[i].FCountRows  :=0;
   FResult[i].FCountBalls :=0;
   FResult[i].FName_ :='';
   FResultBalls[i].FCountRows  :=0;
   FResultBalls[i].FCountBalls :=0;
   FResultBalls[i].FName_ :='';
 end;
end;

function TFileResults.FindPos(rec: TRecFileResult): integer;
var i : integer;
begin
 Result :=0;
 for i := 1 to countRecFileResults do
   if (rec.FCountRows > FResult[i].FCountRows) or
      ((rec.FCountRows = FResult[i].FCountRows) and (rec.FCountBalls > FResult[i].FCountBalls))
    then begin
     Result :=i;
     break;
   end;
end;

function TFileResults.FindPosBall(rec: TRecFileResult): integer;
var i : integer;
begin
 Result :=0;
 for i := 1 to countRecFileResults do
   if (rec.FCountBalls > FResultBalls[i].FCountBalls) or
      ((rec.FCountBalls = FResultBalls[i].FCountBalls) and (rec.FCountRows > FResultBalls[i].FCountRows))
    then begin
     Result :=i;
     break;
   end;
end;

procedure TFileResults.InsRes(rec: TRecFileResult);
var i,j : integer;
begin
 i :=FindPos(rec);
 if i > 0 then begin
   for j :=countRecFileResults-1 downto i do
     FResult[j+1] :=FResult[j];
   FResult[i] :=rec;
 end;
end;

procedure TFileResults.InsResBall(rec: TRecFileResult);
var i,j : integer;
begin
 i :=FindPosBall(rec);
 if i > 0 then begin
   for j :=countRecFileResults-1 downto i do
     FResultBalls[j+1] :=FResultBalls[j];
   FResultBalls[i] :=rec;
 end;
end;

procedure TFileResults.Load_;
var f : TMemoryStream;
    i : integer;
    n,k : string;
    index_ : integer;
    fcurr : ^byte;
    factor_ : boolean;

 function getStr : string;
  begin
    Result :='';
    while (index_ < f.Size) and (fcurr^ <> 13) do begin
      if fcurr^ = 0 then raise EFileError.Create('');
      Result :=Result + chr(fcurr^);
      inc(fcurr);
      inc(index_);
    end; //while
    if index_ < f.Size then begin
      inc(index_);
      inc(fcurr);
    end;
  end;

begin
 Clear;
//   
 n :=Application.ExeName;
 for i := length(n) downto 1 do
   if n[i] = '\' then begin
     n :=copy(n,1,i) +  fileResults;
     break;
   end;
 try
   f :=TMemoryStream.Create;
   try
// 
     f.LoadFromFile(n);
//
     k :=keyChiper;
     ChiperXOR(f.Memory,@(k[1]),f.Size,length(k));
// 
     index_ :=0; fcurr :=f.Memory; i :=1; factor_ :=false;
     n :=getStr;
     if n <> keyChiper then raise EFileError.Create('');
     while index_ < f.Size do begin
       n :=getStr;
       if not factor_ and (n = keyChiper2) then begin
         i :=1;
         factor_ :=true;
        end else begin
           if i > countRecFileResults then EFileError.Create('');
           try
             if not factor_  then begin
               FResult[i].FCountRows :=StrToInt(n);
               if index_ >= f.Size then EFileError.Create('');
               n :=getStr;
               FResult[i].FCountBalls :=StrToInt(n);
               if index_ >= f.Size then EFileError.Create('');
               n :=getStr;
               FResult[i].FName_ :=n;
             end else begin
               FResultBalls[i].FCountRows :=StrToInt(n);
               if index_ >= f.Size then EFileError.Create('');
               n :=getStr;
               FResultBalls[i].FCountBalls :=StrToInt(n);
               if index_ >= f.Size then EFileError.Create('');
               n :=getStr;
               FResultBalls[i].FName_ :=n;
             end;
           except
             on EConvertError do raise EFileError.Create('');
           end;
           inc(i);
       end;
     end; //while
   finally
     f.Free;
   end;
 except
   on EFileError do begin
     MessageBox(SDIAppForm.Handle,'    ',PChar(SDIAppForm.Caption),MB_OK + MB_ICONINFORMATION);
     Clear;
   end;
   on EFOpenError do begin
     Clear;
   end;
 end;
end;

procedure TFileResults.Save_;
var f : TMemoryStream;
    n,k : string;
    i : integer;
begin
 f :=TMemoryStream.Create;
 try
   n :=keyChiper + chr(13);
   f.Write(n[1],length(n));
   for i  :=1 to countRecFileResults do
     if (FResult[i].FCountRows > 0) or (FResult[i].FCountBalls > 0) then begin
       n :=IntToStr(FResult[i].FCountRows) + chr(13);
       f.Write(n[1],length(n));
       n :=IntToStr(FResult[i].FCountBalls) + chr(13);
       f.Write(n[1],length(n));
       n :=FResult[i].FName_ + chr(13);
       f.Write(n[1],length(n));
     end else break;
   n :=keyChiper2 + chr(13);
   f.Write(n[1],length(n));
   for i  :=1 to countRecFileResults do
     if (FResultBalls[i].FCountRows > 0) or (FResultBalls[i].FCountBalls > 0) then begin
       n :=IntToStr(FResultBalls[i].FCountRows) + chr(13);
       f.Write(n[1],length(n));
       n :=IntToStr(FResultBalls[i].FCountBalls) + chr(13);
       f.Write(n[1],length(n));
       n :=FResultBalls[i].FName_ + chr(13);
       f.Write(n[1],length(n));
     end else break;

// 
   k :=keyChiper;
   ChiperXOR(f.Memory,@(k[1]),f.Size,length(k));
//   
   n :=Application.ExeName;
   for i := length(n) downto 1 do
     if n[i] = '\' then begin
       n :=copy(n,1,i) +  fileResults;
       break;
     end;
//  
   f.SaveToFile(n);
 finally
   f.Free;
 end;
end;

procedure TFileResults.ShowResults;
var f : TFormTableResults;
begin
 f :=TFormTableResults.Create(Application);
 f.FFile_ :=self;
 f.RadioGroup1.OnClick(f.RadioGroup1);
 f.ShowModal;
end;

end.
