#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDateTime>
#include <QKeyEvent>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    qsrand(QDateTime::currentDateTime().toTime_t()); //инициализирую генератор случайных чисел

    ui->setupUi(this);
    glassMen  = new Glass(ui->widget_glass_men,ui->widget_prompt_men);
    glassMen->label_count_fill_rows =ui->label_rows;
    glassMen->label_cont_balls =ui->label_balls;
//    glassComp = new Glass(ui->widget_glass_comp,ui->widget_prompt_comp);

    _application =NULL;
}

MainWindow::~MainWindow(){
    if(_application != NULL) _application->removeEventFilter(this);

    delete glassMen;
    delete ui;
}

void MainWindow::on_ButtonStart_clicked()
{
    glassMen->start();
}

void MainWindow::setFilterKeys(QApplication* _app){
    _app->installEventFilter(this);
    _application =_app;
}

bool MainWindow::eventFilter(QObject *, QEvent *ev){
    bool _result =false;
    if(glassMen->isStart() && (ev->type() == QEvent::KeyPress)){
        QKeyEvent* _key_ev = dynamic_cast<QKeyEvent*>(ev);
        switch(_key_ev->key()){
           case Qt::Key_Down  : glassMen->moveFigure(0,-1); _result =true; break;
           case Qt::Key_Left  : glassMen->moveFigure(-1,0); _result =true; break;
           case Qt::Key_Right : glassMen->moveFigure(1,0);  _result =true; break;
           case Qt::Key_Up    : glassMen->moveFigure(0,0);  _result =true; break;
           case Qt::Key_Space :
            while(glassMen->moveFigure(0,-1)) ;
            break;
           default: break;
        }

    }
    return _result;
}
