#ifndef FIGURES_H
#define FIGURES_H

#include <QWidget>
#include <QLabel>

struct IntPoint{int x,y;};

IntPoint point(int x,int y);

struct Squares{ //квадраты фигуры задаются относительно sq_1 (первого квадрата)
    IntPoint sq_1,sq_2,sq_3,sq_4;
};

class Figure{
    public:
        void rotate_();
        IntPoint _sq_break_move[4];
        Squares _squares;
        Figure();
        virtual ~Figure(){} //Чтобы класс был полиморфным
        void get_size(int* xl, int*xr, int* yt, int* yb);
};//class_figure

class FigureA : public Figure{
/*          _ _ _ _
 * фигура: |_|_|_|_|
 *            |
 *       вращение
*/

    public:
        FigureA();
};

class FigureB : public Figure{
/*            _
 *          _|_|_
 * фигура: |_|_|_|
 *            |
 *        вращение
*/

    public:
        FigureB();
};

class FigureC : public Figure{
/*          _ _ _
 * фигура: |_|_|_|
 *            ||_|
 *            |
 *         вращение
*/

    public:
        FigureC();
};

class FigureD : public Figure{
/*          _ _ _
 * фигура: |_|_|_|
 *         |_||
 *            |
 *         вращение
*/

    public:
        FigureD();
};

class FigureE : public Figure{
/*          _ _
 * фигура: |_|_|
 *         |_|_|
 *            |
 *        вращение
*/

    public:
        FigureE();
};

class FigureF : public Figure{
/*          _ _
 * фигура: |_|_|_
 *           |_|_|
 *            |
 *         вращение
*/

    public:
        FigureF();
};

class FigureG : public Figure{
/*            _ _
 * фигура:  _|_|_|
 *         |_|_|
 *            |
 *         вращение     */

    public:
        FigureG();
};

const int min_x = 0;
const int max_x = 9;
const int min_y = 0;
const int max_y = 24;
const int side_small_square = 20; //сторона квадрата в окне подсказки
const int side_square =25; //сторона квадрата в стакане

class Glass : public QObject{
    Q_OBJECT

    protected:
        int _array[max_x+1][max_y+1]; //Стакан представлен ввиде массива _array 0 - свободно, 1 - занято
        QPixmap* _pixmap;
        QWidget* _widget;
        QPixmap* _prompt_pixmap;
        QWidget* _prompt_widget;

        Figure* _figure;
        Figure* _figure_next;

        QTimer* _timer;
        int _timer_interval;

        int _count_fill_rows; //количество убраннных рядов
        int _count_balls;     //количество очков
        double _factor_mul_balls; //коэффициент умножения очков, связанный со скоростью

        bool eventFilter(QObject *obj, QEvent *ev);
        void out_element(IntPoint p, QRect* rect_repaint, bool is_set_recr_repaint=false, bool is_empty =true, bool is_small =false, int l =0, int t=0 );

        void outFigure(bool out_Next =false);
        void clear_array();
        Figure* getFigure();
        void nextFigure();
        bool checkLine(int y);
        void removeLines();
        void set_count_fill_rows(int _value);
        void set_count_balls(int _value);

    protected slots:
        void _update();

    public:
        QLabel* label_count_fill_rows;
        QLabel* label_cont_balls;
        Glass(QWidget* _w,QWidget* _prompt_w);
        ~Glass();
        void clear_widget();
        void clear_prompt_widget();
        bool moveFigure(int x, int y);
        void start();
        void stop();
        bool isStart();
};


#endif // FIGURES_H
