#include "figures.h"
#include <QPainter>
#include <QStylePainter>
#include <QObject>
#include <QEvent>
#include <QPaintEvent>
#include <QTimer>

IntPoint point(int x,int y){
    IntPoint _r;
    _r.x =x;
    _r.y =y;
    return _r;
}

void Figure::rotate_(){
    IntPoint p;
    //Вращение происходит по часовой стрелки вокруг первого квадрата. Центр системы в первом квадрате, ось Y вверх, ось X вправо.
    p.x =_squares.sq_2.y; p.y =-_squares.sq_2.x; _squares.sq_2 =p;
    p.x =_squares.sq_3.y; p.y =-_squares.sq_3.x; _squares.sq_3 =p;
    p.x =_squares.sq_4.y; p.y =-_squares.sq_4.x; _squares.sq_4 =p;

    for(unsigned i=0; i < sizeof(_sq_break_move) / sizeof(Squares); i++){
        p.x  =_sq_break_move[i].y; p.y =-_sq_break_move[i].x; _sq_break_move[i] =p;
    }
}

void Figure::get_size(int* xl, int*xr, int* yt, int* yb){
    *xl =0; *xr=0; *yt=0; *yb=0;

    if(*xl > _squares.sq_2.x) *xl =_squares.sq_2.x;
    if(*xl > _squares.sq_3.x) *xl =_squares.sq_3.x;
    if(*xl > _squares.sq_4.x) *xl =_squares.sq_4.x;

    if(*xr < _squares.sq_2.x) *xr =_squares.sq_2.x;
    if(*xr < _squares.sq_3.x) *xr =_squares.sq_3.x;
    if(*xr < _squares.sq_4.x) *xr =_squares.sq_4.x;

    if(*yt < _squares.sq_2.y) *yt =_squares.sq_2.y;
    if(*yt < _squares.sq_3.y) *yt =_squares.sq_3.y;
    if(*yt < _squares.sq_4.y) *yt =_squares.sq_4.y;

    if(*yb > _squares.sq_2.y) *yb =_squares.sq_2.y;
    if(*yb > _squares.sq_3.y) *yb =_squares.sq_3.y;
    if(*yb > _squares.sq_4.y) *yb =_squares.sq_4.y;
}

Figure::Figure(){
    for(unsigned i=0; i < sizeof(_sq_break_move) / sizeof(Squares); i++)
        _sq_break_move[i] =point(0,0);
    _squares.sq_1 =point(0,0);
}

FigureA::FigureA(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(1,0);
    _squares.sq_4 =point(2,0);

    _sq_break_move[0] =point(-1,1);
    _sq_break_move[1] =point(0,1);
    _sq_break_move[2] =point(1,-1);
    _sq_break_move[3] =point(2,-1);
}

FigureB::FigureB(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(0,1);
    _squares.sq_4 =point(1,0);

    _sq_break_move[0] =point(-1,1);
    _sq_break_move[1] =point(1,1);
    _sq_break_move[2] =point(1,-1);
}

FigureC::FigureC(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(1,0);
    _squares.sq_4 =point(1,-1);

    _sq_break_move[0] =point(0,-1);
    _sq_break_move[1] =point(-1,1);
}

FigureD::FigureD(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(-1,-1);
    _squares.sq_4 =point(1,0);

    _sq_break_move[0] =point(0,-1);
    _sq_break_move[1] =point(0,1);
}

FigureE::FigureE(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(-1,1);
    _squares.sq_4 =point(0,1);

    _sq_break_move[0] =point(1,1);
    _sq_break_move[1] =point(1,0);
}

FigureF::FigureF(){
    _squares.sq_2 =point(-1,1);
    _squares.sq_3 =point(0,1);
    _squares.sq_4 =point(1,0);

    _sq_break_move[0] =point(1,1);
    _sq_break_move[1] =point(1,-1);
}

FigureG::FigureG(){
    _squares.sq_2 =point(-1,0);
    _squares.sq_3 =point(0,1);
    _squares.sq_4 =point(1,1);

    _sq_break_move[0] =point(1,0);
    _sq_break_move[1] =point(-1,1);
}

/* ------------------- Glass -------------------- */
Glass::Glass(QWidget* _w,QWidget* _prompt_w) : QObject(){
    clear_array();

    _widget =_w;
    _pixmap =new QPixmap(_widget->width(),_widget->height());
    clear_widget();
    _w->installEventFilter(this);

    _prompt_widget =_prompt_w;
    _prompt_pixmap =new QPixmap(_prompt_widget->width(),_prompt_widget->height());
    clear_prompt_widget();
    _prompt_w->installEventFilter(this);

    _figure =NULL;
    _figure_next =NULL;

    _count_fill_rows = 0;
    _count_balls = 0;
    _factor_mul_balls =1;

    _timer_interval =800;
    _timer =new QTimer(this);
     connect(_timer, SIGNAL(timeout()), this, SLOT(_update()));

     label_count_fill_rows = NULL;
     label_cont_balls = NULL;
}

Glass::~Glass(){
    disconnect(_timer, SIGNAL(timeout()), this, SLOT(_update()));
    if(_timer->isActive()) _timer->stop();
    delete _timer;

    if(_figure != NULL) delete _figure;
    if(_figure_next !=NULL) delete _figure_next;

    _widget->removeEventFilter(this);
    delete _pixmap;
    delete _prompt_pixmap;
}

bool Glass::eventFilter(QObject *obj, QEvent *ev){
    if(ev->type() == QEvent::Paint){
        QRect _r =dynamic_cast<QPaintEvent*>(ev)->rect();
        QWidget* _w;
        QPixmap* _pix;

        if(obj == _widget){
            _w = _widget;
            _pix = _pixmap;
        }else{
            _w = _prompt_widget;
            _pix = _prompt_pixmap;
        }

        QStylePainter _p(_w);
        _p.drawPixmap(_r,*_pix,_r);
        return true;
    }else return false;
}

void Glass::clear_widget(){
    QPainter _p(_pixmap);
    _p.setPen(QPen(Qt::white,1,Qt::SolidLine));
    _p.setBrush(QBrush(Qt::lightGray,Qt::SolidPattern));
    _p.drawRect(0,0,_pixmap->width()-1,_pixmap->height()-1);

//рисую сетку
    for(int i =min_x, x =side_square +1; i < max_x; i++, x +=side_square +1)
        _p.drawLine(x,1,x,_pixmap->height()-1);
    for(int i =min_y, y =side_square +1; i < max_y; i++, y +=side_square+1)
        _p.drawLine(1,y,_pixmap->width()-1,y);
}

void Glass::clear_prompt_widget(){
    QPainter _p(_prompt_pixmap);
    _p.setPen(QPen(Qt::black,1,Qt::SolidLine));
    _p.setBrush(QBrush(Qt::lightGray,Qt::SolidPattern));
    _p.drawRect(0,0,_prompt_pixmap->width()-1,_prompt_pixmap->height()-1);
}

void Glass::out_element(IntPoint p, QRect* rect_repaint, bool is_set_recr_repaint, bool is_empty, bool is_small, int l, int t){
    QRect r;
    QPixmap* _pix;
    if(is_small){
        r.setTop(t-p.y*(side_small_square+1));  r.setBottom(r.top()+side_small_square-1);
        r.setLeft(l+(p.x)*(side_small_square+1)); r.setRight(r.left() + side_small_square-1);
        _pix =_prompt_pixmap;
    }else{
        _pix =_pixmap;
        r.setTop(_pix->height()-1 - (p.y+1) * (side_square+1)); r.setBottom(r.top() + side_square -1);
        r.setLeft(p.x*(side_square+1)+1); r.setRight(r.left() + side_square-1);
    }

    //устанавливаю границы перерисовки
    if(is_set_recr_repaint){
        rect_repaint->setLeft(r.left());
        rect_repaint->setTop(r.top());
        rect_repaint->setRight(r.right());
        rect_repaint->setBottom(r.bottom());
    }else{
            if(r.left()   < rect_repaint->left())   rect_repaint->setLeft(r.left());
            if(r.top()    < rect_repaint->top())    rect_repaint->setTop(r.top());
            if(r.right()  > rect_repaint->right())  rect_repaint->setRight(r.right());
            if(r.bottom() > rect_repaint->bottom()) rect_repaint->setBottom(r.bottom());
        }

    QPainter _p(_pix);
    if(is_empty){
        _p.fillRect(r,Qt::lightGray);
    }else{
        _p.setPen(QPen(Qt::black,1,Qt::SolidLine));
        _p.setBrush(QBrush(Qt::gray,Qt::SolidPattern));
        r.setWidth(r.width()-1); r.setHeight(r.height() -1); _p.drawRect(r); //1 - толщина пера
    }
}

void Glass::outFigure(bool out_Next){
    int l=0, t=0;
    Figure* f;
    QWidget* w;

    if(out_Next){
        f = this->_figure_next;
        int xl =0,xr =0,yt=0,yb=0;
        f->get_size(&xl,&xr,&yt,&yb);
        f->_squares.sq_1.x = f->_squares.sq_1.x - xl; //смещаю вправо на величину квадратов, находящихся слева от 1
        f->_squares.sq_1.y = f->_squares.sq_1.y - yt; //по аналогии со смещением по горизонтали
        l =(_prompt_pixmap->width() - (xr-xl +1) * side_small_square) / 2;
        t =(_prompt_pixmap->height() - (yt-yb+1) * side_small_square) / 2;
        w = _prompt_widget;
    }else{
        f = this->_figure;
        w = _widget;
    }

//Заданы значения, которые будут заведомо изменены в функции out_element. Выбран _pixmap, так как его размеры больше чем _prompt_pixmap.
    QRect _rect_repaint;
    bool is_first_point =true;
    for(int i=1; i < 5; i++){
        IntPoint p;
        switch(i){
          case 1: p =f->_squares.sq_1; break;
          case 2: p =point(f->_squares.sq_1.x + f->_squares.sq_2.x,f->_squares.sq_1.y + f->_squares.sq_2.y); is_first_point=false; break;
          case 3: p =point(f->_squares.sq_1.x + f->_squares.sq_3.x,f->_squares.sq_1.y + f->_squares.sq_3.y); break;
          default:
            p =point(f->_squares.sq_1.x + f->_squares.sq_4.x,f->_squares.sq_1.y + f->_squares.sq_4.y);
            break;
        }
        if(out_Next || ((p.x >= min_x) && (p.x <= max_x) && (p.y >= min_y) && (p.y <= max_y) && (_array[p.x][p.y] ==0)))
            out_element(p,&_rect_repaint,is_first_point,false,out_Next,l,t);
    }//for

//Запускаю перерисовку
    w->repaint(_rect_repaint);
}

void Glass::clear_array(){
    for(int x =min_x; x <= max_x; x++)
        for(int y =min_y; y <=max_y; y++)
            _array[x][y] =0;
}

bool Glass::moveFigure(int x, int y){
    bool _result = true;
    Squares curr_ =_figure->_squares;

//Если вращение, проверяю блокирующие позиции
    if((x == 0) && (y == 0))
        for(unsigned i=0; i < sizeof(_figure->_sq_break_move) / sizeof(Squares); i++){
            IntPoint p = point(_figure->_squares.sq_1.x + _figure->_sq_break_move[i].x,_figure->_squares.sq_1.y + _figure->_sq_break_move[i].y);
            if(((p.x != _figure->_squares.sq_1.x) || (p.y != _figure->_squares.sq_1.y)) &&
               ((p.x < min_x) || (p.x > max_x) || (p.y < min_y) || (p.y > max_y) || (_array[p.x][p.y] ==1))){
                _result = false;
                break;
            }
        }

//Произвожу перемещение/вращение
    if (_result){
        if((x==0) && (y ==0))
            _figure->rotate_();
        else{
            _figure->_squares.sq_1.x +=x;
            _figure->_squares.sq_1.y +=y;
        }
//Проверяю результат перемещения/вращения
        if((_figure->_squares.sq_1.x < min_x) ||
           (_figure->_squares.sq_1.x > max_x) ||
           (_figure->_squares.sq_1.y < min_y) ||
           (_figure->_squares.sq_1.y > max_y) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_2.x < min_x) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_2.x > max_x) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_2.y < min_y) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_2.y > max_y) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_3.x < min_x) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_3.x > max_x) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_3.y < min_y) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_3.y > max_y) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_4.x < min_x) ||
           (_figure->_squares.sq_1.x + _figure->_squares.sq_4.x > max_x) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_4.y < min_y) ||
           (_figure->_squares.sq_1.y + _figure->_squares.sq_4.y > max_y) ||
           (_array[_figure->_squares.sq_1.x][_figure->_squares.sq_1.y] == 1) ||
           (_array[_figure->_squares.sq_1.x + _figure->_squares.sq_2.x][_figure->_squares.sq_1.y + _figure->_squares.sq_2.y] == 1) ||
           (_array[_figure->_squares.sq_1.x + _figure->_squares.sq_3.x][_figure->_squares.sq_1.y + _figure->_squares.sq_3.y] == 1) ||
           (_array[_figure->_squares.sq_1.x + _figure->_squares.sq_4.x][_figure->_squares.sq_1.y + _figure->_squares.sq_4.y] == 1)){
            _result =false;
            _figure->_squares =curr_;
        }
    }

//Перерисовываю фигуру
    if(_result){
        outFigure();
        QRect _rect_repaint;
        if(((curr_.sq_1.x !=_figure->_squares.sq_1.x) || (curr_.sq_1.y !=_figure->_squares.sq_1.y)) &&
           ((curr_.sq_1.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_2.x) || (curr_.sq_1.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_2.y)) &&
           ((curr_.sq_1.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_3.x) || (curr_.sq_1.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_3.y)) &&
           ((curr_.sq_1.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_4.x) || (curr_.sq_1.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_4.y))){
                out_element(curr_.sq_1,&_rect_repaint,true);
                _widget->repaint(_rect_repaint);
        }
        if(((curr_.sq_1.x+curr_.sq_2.x !=_figure->_squares.sq_1.x) || (curr_.sq_1.y+curr_.sq_2.y !=_figure->_squares.sq_1.y)) &&
           ((curr_.sq_1.x+curr_.sq_2.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_2.x) || (curr_.sq_1.y+curr_.sq_2.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_2.y)) &&
           ((curr_.sq_1.x+curr_.sq_2.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_3.x) || (curr_.sq_1.y+curr_.sq_2.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_3.y)) &&
           ((curr_.sq_1.x+curr_.sq_2.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_4.x) || (curr_.sq_1.y+curr_.sq_2.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_4.y))){
                out_element(point(curr_.sq_1.x+curr_.sq_2.x,curr_.sq_1.y+curr_.sq_2.y),&_rect_repaint,true);
                _widget->repaint(_rect_repaint);
        }
        if(((curr_.sq_1.x+curr_.sq_3.x !=_figure->_squares.sq_1.x) || (curr_.sq_1.y+curr_.sq_3.y !=_figure->_squares.sq_1.y)) &&
           ((curr_.sq_1.x+curr_.sq_3.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_2.x) || (curr_.sq_1.y+curr_.sq_3.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_2.y)) &&
           ((curr_.sq_1.x+curr_.sq_3.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_3.x) || (curr_.sq_1.y+curr_.sq_3.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_3.y)) &&
           ((curr_.sq_1.x+curr_.sq_3.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_4.x) || (curr_.sq_1.y+curr_.sq_3.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_4.y))){
                out_element(point(curr_.sq_1.x+curr_.sq_3.x,curr_.sq_1.y+curr_.sq_3.y),&_rect_repaint,true);
                _widget->repaint(_rect_repaint);
        }
        if(((curr_.sq_1.x+curr_.sq_4.x !=_figure->_squares.sq_1.x) || (curr_.sq_1.y+curr_.sq_4.y !=_figure->_squares.sq_1.y)) &&
           ((curr_.sq_1.x+curr_.sq_4.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_2.x) || (curr_.sq_1.y+curr_.sq_4.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_2.y)) &&
           ((curr_.sq_1.x+curr_.sq_4.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_3.x) || (curr_.sq_1.y+curr_.sq_4.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_3.y)) &&
           ((curr_.sq_1.x+curr_.sq_4.x !=_figure->_squares.sq_1.x+_figure->_squares.sq_4.x) || (curr_.sq_1.y+curr_.sq_4.y !=_figure->_squares.sq_1.y+_figure->_squares.sq_4.y))){
                out_element(point(curr_.sq_1.x+curr_.sq_4.x,curr_.sq_1.y+curr_.sq_4.y),&_rect_repaint,true);
                _widget->repaint(_rect_repaint);
        }
    }

    return _result;
}

Figure* Glass::getFigure(){
    Figure* _result;

    switch(qrand() % 7){
        case 0 : _result =new FigureA(); break;
        case 1 : _result =new FigureB(); break;
        case 2 : _result =new FigureC(); break;
        case 3 : _result =new FigureD(); break;
        case 4 : _result =new FigureE(); break;
        case 5 : _result =new FigureF(); break;
        default :
            _result =new FigureG(); break;
    }

    return _result;
}

void Glass::nextFigure(){
    if(_figure_next != NULL){
        delete _figure;
        _figure =_figure_next;
    }else _figure =getFigure();
    _figure->_squares.sq_1 =point(0,0);

    _figure_next =getFigure();
//Очищаю окно подсказки
    clear_prompt_widget();
    _prompt_widget->repaint();
//Вывожу подсказку
    outFigure(true);
}

void Glass::start(){
    if(_figure ==NULL) nextFigure();
    _timer->start(_timer_interval);
}

void Glass::stop(){
    _timer->stop();
}

void Glass::_update(){
//Фигура ещё не появилась в окне
    if((_figure->_squares.sq_1.x==0) && (_figure->_squares.sq_1.y==0)){
//Определяю центр
        if(dynamic_cast<FigureE*>(_figure))
            _figure->_squares.sq_1.x =6;
        else
            _figure->_squares.sq_1.x =5;

        _figure->_squares.sq_1.y =max_y;

//Определяю возможность показа фигуры
        Figure* _f =_figure; //Для более компактной записи
        if(((_f->_squares.sq_1.y <= max_y) && (_array[_f->_squares.sq_1.x][_f->_squares.sq_1.y] ==1)) ||
           ((_f->_squares.sq_1.y+_f->_squares.sq_2.y  <= max_y) && (_array[_f->_squares.sq_1.x+_f->_squares.sq_2.x][_f->_squares.sq_1.y+_f->_squares.sq_2.y] ==1)) ||
           ((_f->_squares.sq_1.y+_f->_squares.sq_3.y  <= max_y) && (_array[_f->_squares.sq_1.x+_f->_squares.sq_3.x][_f->_squares.sq_1.y+_f->_squares.sq_3.y] ==1)) ||
           ((_f->_squares.sq_1.y+_f->_squares.sq_4.y  <= max_y) && (_array[_f->_squares.sq_1.x+_f->_squares.sq_4.x][_f->_squares.sq_1.y+_f->_squares.sq_4.y] ==1))){
            this->stop();
        }else
            outFigure();

    }else{
//Фигура выведена, опускаю
        if(!moveFigure(0,-1)){
            bool f =true;
            if(_figure->_squares.sq_1.y <= max_y)
                _array[_figure->_squares.sq_1.x][_figure->_squares.sq_1.y] =1;
            else f =false;
            if(_figure->_squares.sq_1.y+_figure->_squares.sq_2.y <= max_y)
                _array[_figure->_squares.sq_1.x+_figure->_squares.sq_2.x][_figure->_squares.sq_1.y+_figure->_squares.sq_2.y] =1;
            else f =false;
            if(_figure->_squares.sq_1.y+_figure->_squares.sq_3.y <= max_y)
                _array[_figure->_squares.sq_1.x+_figure->_squares.sq_3.x][_figure->_squares.sq_1.y+_figure->_squares.sq_3.y] =1;
            else f =false;
            if(_figure->_squares.sq_1.y+_figure->_squares.sq_4.y <= max_y)
                _array[_figure->_squares.sq_1.x+_figure->_squares.sq_4.x][_figure->_squares.sq_1.y+_figure->_squares.sq_4.y] =1;
            else f =false;

            if(f) set_count_balls(_count_balls +qRound(4 * _factor_mul_balls));
            removeLines();
            delete _figure; _figure=NULL;
            if(f)
                nextFigure();
            else{
                stop();
            }
        }
    }
}

bool Glass::isStart(){
    return _timer->isActive();
}

bool Glass::checkLine(int y){
    bool _r =true;
    for(int x = min_x; (x <=max_x) && _r; x++)
        if(_array[x][y] == 0)
            _r=false;
    return _r;
}

void Glass::removeLines(){
    int order_[max_y+1];

    int i =min_y, k =-1, _factor2 =0;
    for(int j =min_y; j <=max_y; j++)
        if(!checkLine(j))
            order_[i++] =j;
        else{
            if(k ==-1) k =j;
            set_count_fill_rows(_count_fill_rows+1);
            set_count_balls(_count_balls + qRound(max_x * _factor_mul_balls * ++_factor2));
        }
    if(k !=-1){
        for(int j=i; j <= max_y; j++) order_[j] =-1;

        for(i=min_y; i <=max_y; i++){
            if(order_[i] !=i){
                if(order_[i] !=-1){
                    for(int j =min_x; j <=max_x; j++)
                        _array[j][i] =_array[j][order_[i]];
                }else
                    for(int j =min_x; j <=max_x; j++)
                        _array[j][i] =0;
            }
        }

        QRect _rect_repaint;
        for(i =k; i <=max_y; i++)
            for(int j=min_x; j <=max_x; j++)
                out_element(point(j,i), &_rect_repaint, (i==k) && (j ==min_x), _array[j][i]==0);
        _widget->repaint(_rect_repaint);
    }
}

void Glass::set_count_fill_rows(int _value){
    _count_fill_rows =_value;
    if(label_count_fill_rows != NULL){
        QString _str_value;
        _str_value.setNum(_count_fill_rows);
        label_count_fill_rows->setText(_str_value);
    }

    int _a;
    if((_count_fill_rows >= 0) && (_count_fill_rows <= 10)) _a=800;
        else if((_count_fill_rows >= 11) && (_count_fill_rows <= 20)) _a=700;
        else if((_count_fill_rows >= 21) && (_count_fill_rows <= 30)) _a=600;
        else if((_count_fill_rows >= 31) && (_count_fill_rows <= 40)) _a=500;
        else if((_count_fill_rows >= 41) && (_count_fill_rows <= 50)) _a=400;
        else if((_count_fill_rows >= 51) && (_count_fill_rows <= 60)) _a=300;
        else if((_count_fill_rows >= 61) && (_count_fill_rows <= 70)) _a=200;
        else if((_count_fill_rows >= 71) && (_count_fill_rows <= 80)) _a=100;
        else _a =80;
    if(_timer_interval != _a){
        _factor_mul_balls = 800 /_a;
        _timer_interval =_a;
        _timer->setInterval(_timer_interval);
    }
}

void Glass::set_count_balls(int _value){
    _count_balls =_value;
    if(label_cont_balls != NULL){
        QString _str_value;
        _str_value.setNum(_count_balls);
        label_cont_balls->setText(_str_value);
    }
}

